//
//  Access.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "AccessControlList.h"


@interface Access : NSCachedObject {
    SecAccessRef access;
    int error;
}

+ (Access*)accessWithName:(NSString*)name;
+ (Access*)accessWithAccessRef:(SecAccessRef)acc;

- (Access*)initWithName:(NSString*)name;
- (Access*)initWithAccessRef:(SecAccessRef)acc;

- (NSArray*)accessControlLists;

- (NSArray*)accessControlListsForAction:(CSSM_ACL_AUTHORIZATION_TAG)action;
- (NSArray*)accessControlListsForEverything;
- (NSArray*)accessControlListsForLogin;
- (NSArray*)accessControlListsForGeneratingKeys;
- (NSArray*)accessControlListsForDeletion;
- (NSArray*)accessControlListsForExportingWrapped;
- (NSArray*)accessControlListsForExportingClear;
- (NSArray*)accessControlListsForImportingWrapped;
- (NSArray*)accessControlListsForImportingClear;
- (NSArray*)accessControlListsForSigning;
- (NSArray*)accessControlListsForEncrypting;
- (NSArray*)accessControlListsForDecrypting;
- (NSArray*)accessControlListsForMACGeneration;
- (NSArray*)accessControlListsForDerivingKeys;

- (int)lastError;
- (SecAccessRef)accessRef;

@end
